# --------------------------------------------------------------------------------------
#
#  IBM CONFIDENTIAL
#  OCO SOURCE MATERIALS
#
#  COPYRIGHT:  P#2 P#1
#              COPYRIGHT IBM CORPORATION Y1, Y2
#
#  The source code for this program is not published or otherwise divested of
#  its trade secrets, irrespective of what has been deposited with the U.S.
#  Copyright Office.
#
#  Source File Name = (%W%)
#
#  Descriptive Name = Strings for the graphical components of our install
#
#  Function: Map string tokens to values.
#            NLS enablement.
#
#  Dependencies: See import list.
#
#  Restrictions:
#
#  Change Activity:
#  DATE        DESCRIPTION                                             S&D Code
#  ==============================================================================
#  2002/05/13  add this header and special tokens for Java             @d230924rac
#  2002/11/07  add mnemonic for launchpad buttons                      @d254190gyx
#  2002/12/03  update prod names/descriptions for RCON/LSDC (II)       @d262416rac
#  2002/12/28  update copyright info                                   @d263188rac
#  2002/12/30  add prod name/description for Aurora aka cube aka mmm   @d264987rac
#  2002/12/30  add prod name/description for Express                   @d275660rac
#  2003/07/17  update prod description for ese                         @d223246gyx
#  2003/10/21  add prod name/description for Information Center DOCE   @d296504rbv
#  2003/11/08  new V82 launchpad gif image, some strings not needed    @d297739gaf
#  2003/11/12  modify string for launchpad                             @d299782aab
#  2003/11/13  keep all strings, change code for strings not needed    @d300021gaf
#  2003/11/26  add finalized DOCE strings                              @d301757rbv
#  2003/11/27  add DB2UDB key                                          @d299962rbv
#  2004/01/28  modify font sizes                                       @d304784aab
#  2004/01/29  add short product names                                 @d308413aab
#  2004/03/30  windows specific windows names (without mnemonic)       @d319806gaf
#  2004/10/14  added new command line option help /p /c /m             @d351484djp
#  2005/04/01  added initial choice for NLPACK strings                 @w028116hab
#  2005/06/13  adding NLPACK3 description text                         @w036186hab
#  2005/06/15  remove strings related to DLM product                   @w036510hab
#  2005/06/24  added strings for launch.C                              @w036438rya
#  2005/07/06  remove references to DOCS                               @w035675hab
#  2005/07/18  modify ERROR_RSP_* strings                              @w039116rya
#  2005/08/15  add strings for the Picker                              @w041118iz
#  2005/09/01  modify strings for the Picker                           @w046053iz
#  ==============================================================================
#
#  Last Changed = %E% %U%
#
#  --------------------------------------------------------------------------------------
#  Version:  %I%, %G%
#  --------------------------------------------------------------------------------------
#
# NOTES TO TRANSLATORS:
# *********************
#
#    Translatable entries in this file have the form: 
#        STRING_KEY = text value
#    An example is:
#        D391BP_DISP_NONE = None
#
# 1. The first part, the key, is usually uppercased, and is not translated.
#    This is the name of the entry used in the Java code.
#
# 2. The second part is the value of the entry. This is the text that is
#    translated and used at run time.
#
# The pound sign (#) is a comment marker. For a literal #, write \u0023.
#
# Keys that begin with the forward slash (ie "/") are special tokens 
# and should NOT be translated
#
# The folloing is needed to make sure this file will pass the CHKPII check (for
# translation).
# NLS_MESSAGEFORMAT_NONE
#
#====================================================================
# This file is for the language: en_US
# start of special tokens, do not translate
/PACKAGE_NAME = com.ibm.db2.install.resources
/MNEMONIC_SUFFIX = _MNEM
/ACCELERATOR_SUFFIX = _ACCEL
/BASE
# end of special tokens
#====================================================================

INTRO=DB2-Launchpad wird geladen...

TITLE=IBM DB2 Setup - Launchpad
TITLE_BRAND=Information Management Software
VERSION=Version {0}

##################################
# PRODUCT NAMES and DESCRIPTIONS #
##################################

# SERVER

SERVER0=DB2 Server
SERVER2=DB2 Server

# VSAI 

VSAI0=IBM Database-Add-ins fr Visual Studio 2005
VSAI2=IBM Database-Add-ins fr Visual Studio 2005

# DSDRIVER

DSDRIVER0=IBM Data Server Driver for ODBC, CLI, and .NET
DSDRIVER2=IBM Data Server Driver for ODBC, CLI, and .NET

# servers/database engines

ESE0=IBM DB2 Enterprise Server Edition
ESE2=DB2 Enterprise Server Edition
#the <prod_abbr>_G is used by the java gui Product.java for the use by the Launchpad 
ESE_G=DB2 Enterprise Server Edition Version {0}
ESE3=DB2 Enterprise Server Edition wurde speziell fr die Anforderungen von kleinen bis mittleren Unternehmen konzipiert. Das Produkt kann auf Linux-, UNIX- oder Windows-Servern jeder Gre implementiert werden - unabhngig davon, ob eine CPU oder mehrere CPUs vorhanden sind.\n\nDB2 Enterprise Server Edition ist eine ideale Basis fr das Erstellen von unternehmensweiten On Demand-Lsungen, wozu beispielsweise Data Warehouses mit einer Gre von mehreren Terabyte, leistungsstarke, rund um die Uhr verfgbare Unternehmenslsungen fr die Transaktionsverarbeitung oder webbasierte Lsungen zhlen. DB2 Enterprise Server Edition enthlt einen nativen XML-Datenspeicher und ermglicht den flexiblen Zugriff auf XML-Daten mit Hilfe von XQuery, XPath, SQL und Standardberichtstools.\n\nFr DB2 Enterprise Server Edition sind Zusatzfunktionen verfgbar, mit denen das Leistungsspektrum dieses Produkts im Hinblick auf die Datenbankpartitionierung, Leistung, Sicherheit, Datenfderation und Datenbankverwaltung erweitert werden kann. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
ESE4=DB2 Enterprise Server Edition wurde speziell fr die Anforderungen von kleinen bis mittleren Unternehmen konzipiert.

WSE0=IBM DB2 Workgroup Server Edition
WSE2=DB2 Workgroup Server Edition
WSE_G=DB2 Workgroup Server Edition Version {0}
WSE3=DB2 Workgroup Server Edition wurde speziell fr die Anforderungen von kleinen bis mittleren Unternehmen und den Einsatz von Arbeitsgruppen konzipiert. DB2 Workgroup Server Edition enthlt einen nativen XML-Datenspeicher und ermglicht den flexiblen Zugriff auf XML-Daten mit Hilfe von XQuery, XPath, SQL und Standardberichtstools.\n\nFr DB2 Workgroup Server Edition sind Zusatzfunktionen verfgbar, mit denen das Leistungsspektrum dieses Produkts im Hinblick auf die Leistung, die Hochverfgbarkeit, das Workload-Management und die Datenbankfderation erweitert werden kann. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
WSE4=DB2 Workgroup Server Edition wurde speziell fr die Anforderungen von mittleren Unternehmen und den Einsatz von Arbeitsgruppen konzipiert.

EXP0=IBM DB2 Express Edition
EXP2=DB2 Express
EXP_G=DB2 Express Version {0}
EXP3=DB2 Express Edition enthlt einen DB2-Datenserver mit vollem Leistungsumfang, der sich als Einstiegslsung fr den SMB-Bereich (Small and Medium Business) eignet. Dieses Produkt weist eine vereinfachte Konfektionierung auf und kann problemlos aus einer Anwendung heraus installiert werden. Es ist fr Linux- und Windows-Plattformen verfgbar und vollstndig kompatibel mit den Angeboten dieser Produktfamilie in der gehobenen Preisklasse, kann auf diese Angebote erweitert werden und weist deren den autonomen Verwaltungskomfort auf. DB2 Express enthlt einen nativen XML-Datenspeicher und ermglicht den flexiblen Zugriff auf XML-Daten mit Hilfe von XQuery, XPath, SQL und Standardberichtstools.\n\nFr DB2 Express sind Zusatzfunktionen verfgbar, mit denen das Leistungsspektrum dieses Produkts im Hinblick auf die Leistung, das Workload-Management und die Datenbankfderation erweitert werden kann. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
EXP4= DB2 Express Edition enthlt einen DB2-Datenserver mit vollem Leistungsumfang, der sich als Einstiegslsung fr den SMB-Bereich (Small and Medium Business) eignet.


PE0=IBM DB2 Personal Edition
PE2=DB2 Personal Edition
PE_G=DB2 Personal Edition Version {0}
PE3=DB2 Personal Edition ist die Einzelplatzversion einer umfassend ausgestatteten relationalen Datenbank mit integrierter Replikation, die sich ideal fr den desktop- oder laptop-basierten Einsatz eignet. DB2 Personal Edition kann ber Remotezugriff verwaltet werden und eignet sich daher ideal fr den Einsatz in zeitweise verbundenen oder fernen Broanwendungen, die keine Mehrbenutzerfunktionen erfordern. DB2 Personal Edition kann auf Desktop- und Laptop-Workstations unter Linux und Windows verwendet werden, die ber eingehende Datenbankverbindungen verfgen, die nur fr die Verwaltung bestimmt sind.\n\nWeitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
PE4=DB2 Personal Edition ist die Einzelplatzversion einer umfassend ausgestatteten relationalen Datenbank mit integrierter Replikation, die sich ideal fr den desktop- oder laptop-basierten Einsatz eignet.

# connects

CONEE0=IBM DB2 Connect Server
CONEE2=DB2 Connect Server
CONEE_G=DB2 Connect Server Version {0}
CONEE3=DB2 Connect Server-Produkte erfllen die Anforderungen von Unternehmen, fr die die stabile Konnektivitt zwischen einer Vielzahl von Desktopsystemen und Datenbankservern auf Mainframe-Computern oder unter iSeries von grter Wichtigkeit ist. Diese Produkte sind fr eine dreischichtige Umgebung konzipiert, in der DB2-Anwendungsclients ber ein DB2 Connect Server-System mit Mainframe-Datenbanken und mittlere Datenbanken verbunden sind. DB2 Connect-Produkte umfassen DB2-Client-Software, die auf Desktopsystemen implementiert wird und API-Treiber bereitstellt, die auf Desktopsystemen ausgefhrte Client/Server-Anwendungen mit DB2 Connect Server-System verbinden. DB2 Connect Server wurde mit dem Ziel konzipiert, die Konnektivitt fr Client/Server-Anwendungen in anspruchsvollen Umgebungen mit groen Umfang zu gewhrleisten. Daher bietet DB2 Connect Server Funktionen fr das Verbindungspooling und die Verbindungskonzentration, die der Maximierung der Anwendungsverfgbarkeit bei gleichzeitiger Minimierung der Ressourcennutzung von Mainframe-Computern dienen.\n\nDB2 Connect Server-Produkte sind in mehreren Produkteditionen verfgbar. Die Editionen unterscheiden sich dabei in ihren Lizenzbedingungen und dahingehend, dass sie auf verschiedene Einsatzszenarios abzielen. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
CONEE4=DB2 Connect Server-Produkte erfllen die Anforderungen von Unternehmen, fr die die stabile Konnektivitt zwischen einer Vielzahl von Desktopsystemen und Datenbankservern auf Mainframe-Computern oder unter iSeries von grter Wichtigkeit ist.

CONPE0=IBM DB2 Connect Peronal Edition
CONPE2=DB2 Connect Personal Edition
CONPE_G=DB2 Connect Personal Edition Version {0}
CONPE3=DB2 Connect Personal Edition bietet die API-Treiber (API - Anwendungsprogrammierschnittstelle) und die Verbindungsstruktur, um eine direkte Verbindung zwischen Windows- und Linux-Desktopanwendungen und Datenbankservern auf Mainframe-Computern oder unter iSeries herstellen zu knnen. Dieses Produkt wurde speziell fr die Aktivierung zweischichtiger Cient/Server-Anwendungen entworfen und lizenziert, die auf einzelnen Workstations ausgefhrt werden und daher nicht fr die Verwendung auf Servern geeignet sind.\n\nAnders als DB2 Connect Server-Produkte stellt DB2 Connect Personal Edition keine erweiterten Funktionen wie die Untersttzung fderierter Datenbanken, die serverbasierte berwachung oder den Verbindungskonzentrator und die damit verbundenen Untersttzung fr Lastausgleich und Funktionsbernahme bereit. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
CONPE4=DB2 Connect Personal Edition bietet die API-Treiber (API - Anwendungsprogrammierschnittstelle) und die Verbindungsstruktur, um eine direkte Verbindung zwischen Windows- und Linux-Desktopanwendungen und Datenbankservern auf Mainframe-Computern oder unter iSeries herstellen zu knnen.

# clients

CLIENT0=IBM Data Server Client
CLIENT2=IBM Data Server Client
CLIENT_G=IBM Data Server Client Version {0}
CLIENT3=IBM Data Server Client ist eine Sammlung grafischer und nicht grafischer Tools und Komponenten fr die Verwaltung von DB2-Produkten und die Entwicklung von Anwendungen mit DB2-Produkten. Add-ins fr Eclipse- und Microsoft Visual Studio 2005-Entwicklungsumgebungen sind auch enthalten.\n\nIBM Data Server Client ist eine Komponente der Produkte DB2 Server, DB2 Express, DB2 Connect Server und DB2 Connect Personal Edition. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
CLIENT4=IBM Data Server Client ist eine Sammlung grafischer und nicht grafischer Tools und Komponenten fr die Verwaltung von DB2-Produkten und die Entwicklung von Anwendungen mit DB2-Produkten.

RTCL0=IBM Data Server Runtime Client
RTCL2=IBM Data Server Runtime Client
RTCL_G=IBM Data Server Runtime Client Version {0}
RTCL3=IBM Data Server Runtime Client ist ein nicht grafischer Light-Weight-Client, der die Funktionalitt bereitstellt, die Ihre Anwendungen fr den Zugriff auf DB2-Server bentigen. Er bietet Anwendungsuntersttzung fr die Ausfhrung von Anwendungen, die Schnittstellen fr eingebettetes SQL, CLI, JDBC, SQLJ, ODBC, OLE DB, .NET und PHP verwenden.\n\nIBM Data Server Runtime Client ist eine Komponente der Produkte DB2 Server, DB2 Express, DB2 Connect Server und DB2 Connect Personal Edition. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
RTCL4=IBM Data Server Runtime Client ist ein nicht grafischer Light-Weight-Client, der die Funktionalitt bereitstellt, die Ihre Anwendungen fr den Zugriff auf DB2-Server bentigen.

# add on products

LSDC0=Nicht relationale Wrapper fr IBM WebSphere Information Integration
LSDC2=Nicht relationale Wrapper fr WebSphere Information Integration
LSDC_G=Nicht relationale Wrapper fr WebSphere Information Integration Version {0}
LSDC3=Nicht relationale Wrapper fr WebSphere Information Integration ermglichen einem WebSphere Information Integration-System die Intergration genetischer, chemischer, biologischer und anderer Forschungsdaten aus biowissenschaftlichen Datenquellen. \n\nWeitere Informationen finden Sie im Internet unter http://www.ibm.com/software/data/integration/federation_server/.
LSDC4=Nicht relationale Wrapper fr WebSphere Information Integration ermglichen Konnektivitt mit einer Gruppe nicht relationaler Datenquellen.

RCON0=Relationale Wrapper fr IBM WebSphere Information Integration
RCON2=Relationale Wrapper fr WebSphere Information Integration
RCON_G=Relationale Wrapper fr WebSphere Information Integration Version {0}
RCON3=Relationale Wrapper fr WebSphere Information Integration ermglichen es Ihnen, in verteilten relationalen DB2- und Nicht-DB2-Datenbanken befindliche Daten abzufragen und abzurufen. Eine einzelne SQL-Anweisung kann auf eine oder mehrere Datenbanken verweisen. Sie knnen beispielsweise die in einer DB2-Tabelle befindlichen Daten mit den Daten in einer Oracle-Tabelle oder den aus einer Microsoft SQL Server-Sicht abgerufenen Daten verknpfen.\n\nWeitere Informationen finden Sie im Internet unter http://www.ibm.com/software/data/integration/federation_server/.
RCON4=Relationale Wrapper fr WebSphere Information Integration ermglichen ber verteilte Joins Zugriff auf Daten, die in Datenquellen anderer Hersteller gespeichert sind.

QP0=IBM DB2 Query Patroller
QP2=DB2 Query Patroller
QP_G=DB2 Query Patroller Version {0}
QP3=DB2 Query Patroller ist ein Abfragetool fr das Workload-Management, das die bergabe und Ausfhrung von Abfragen proaktiv und dynamisch steuert, um die Auslastung von DB2-Datenbanken besser verwalten zu knnen und somit den Geschftsanforderungen gerecht zu werden. \nDas Produkt ist Teil eines optionalen Angebots, das auf den Produkten DB2 Enterprise Server Edition, DB2 Workgoup Server Edition und DB2 Express Edition aufsetzt. Weitere Informationen finden Sie im Internet unter http://www.ibm.com/db2.
QP4=DB2 Query Patroller ist ein Abfragetool fr das Workload-Management, das die bergabe und Ausfhrung von Abfragen proaktiv und dynamisch steuert, um die Auslastung von DB2-Datenbanken besser verwalten zu knnen.

GSE0=IBM DB2 Spatial Extender
GSE2=DB2 Spatial Extender
GSE_G=DB2 Spatial Extender Version {0}
GSE3=DB2 Spatial Extender nutzt die Leistung des relationalen Datenbankmodells, um auf standortbezogene Informationen einer planen Karte hnlich wie auf traditionelle Geschftsdaten ohne groen Aufwand zugreifen und sie verwalten und analysieren zu knnen. DB2 Spatial Extender verwendet standardisiertes SQL fr rumliche Datentypen und Funktionen. DB2 Spatial Extender ist im Lieferumfang anwendbarer DB2 Server-Produkte enthalten.\n\nWeitere Informationen finden Sie im Internet unter http://www.ibm.com/software/data/spatial/.\n\nDB2 Geodetic Data Management Feature setzt auf DB2 Spatial Extender auf und ermglicht es, die Erde als Kugel und nicht als ebene Landkarte zu behandeln. Dies vereinfacht die Entwicklung von Business-Intelligence- und E-Government-Anwendungen, fr die geografische Positionsanalysen erforderlich sind. DB2 Geodetic Extender ist in der Lage, einen beliebig groen virtuellen Globus zu erstellen. Die meisten Positionsinformationen werden mit Hilfe von weltweiten Systemen wie GPS (Global Positioning Satellite) erfasst und als Koordinaten fr den Breiten- und Lngengrad dargestellt. DB2 Geodetic Data Management Feature ist fr DB2 Enterprise Server Edition optional erhltlich.\n\nWeitere Informationen finden Sie im Internet unter http://www.ibm.com/software/data/spatial/db2geodetic/.
GSE4=Mit DB2 Spatial Extender knnen Sie in DB2 Server-Produkten gespeicherte Geodaten (Informationen zur Position geografischer Komponenten) speichern, verwalten und analysieren.

NLPACK0=IBM DB2-Landessprachenpaket
NLPACK2=DB2-Landessprachenpaket
NLPACK_G=DB2-Landessprachenpaket Version {0}
NLPACK3=Das DB2-Landessprachenpaket fgt Ihren DB2-Produkten die Untersttzung landessprachlicher Versionen hinzu. Sie knnen die Untersttzung landessprachlicher Versionen jederzeit hinzufgen, um Ihre DB2-Produkte zu lokalisieren.
NLPACK4=Das DB2-Landessprachenpaket fgt Ihren DB2-Produkten die Untersttzung landessprachlicher Versionen hinzu. Sie knnen die Untersttzung landessprachlicher Versionen jederzeit hinzufgen, um Ihre DB2-Produkte zu lokalisieren.

# IC and other weirdos

DOCE0=IBM DB2-Informationszentrale
DOCE2=DB2-Informationszentrale
DOCE_G=DB2 Version {0} - Informationszentrale
DOCE3=Die DB2-Informationszentrale enthlt die Dokumentation fr DB2-Produkte. Diese Komponente deckt jeden Aspekt von DB2 ab, von den ersten Schritten ber Datenbankkonnektivitt, Datenbankverwaltung, Abfrageverwaltung und Business-Intelligence bis hin zur Anwendungsentwicklung. Die DB2-Informationszentrale ist vollstndig durchsuchbar und fr einen schnellen Zugriff auf DB2-Produktinformationen konzipiert.\n\nMit Hilfe des DB2-Installationsassistenten knnen Sie die DB2-Informationszentrale zusammen mit Ihrer DB2-Software lokal auf Ihrem Computer installieren. Befindet sich der Computer, auf dem Sie die DB2-Informationszentrale installieren, in einem Netzwerk, knnen auch andere Computer ber einen Web-Browser auf sie zugreifen. Auf diese Weise knnen Sie mit Ihren DB2-Produkten ber das Netz auf eine gemeinsame Version der DB2-Informationszentrale zugreifen - sowohl ber den Computer, auf dem die DB2-Informationszentrale installiert ist, als auch ber die IBM Website.\n\nAktualisierungen fr die DB2-Informationszentrale werden von Zeit zu Zeit zum Download bereitgestellt. Wenn Sie mchten, dass Benutzer stets auf die aktuellen Informationen zugreifen, ohne dass Sie stndig an das Installieren der neuesten Aktualisierungen denken mssen, knnen Sie DB2-Produkte auch so konfigurieren, dass sie auf die DB2-Informationszentrale auf der IBM Website zugreifen. Die Version der DB2-Informationszentrale auf der IBM Website wird nach Bedarf aktualisiert, so dass jeweils die neueste Version von DB2 beschrieben wird.
DOCE4=Die DB2-Informationszentrale enthlt die Dokumentation fr DB2-Produkte. Sie deckt jeden Aspekt von DB2 ab, von den ersten Schritten ber Datenbankkonnektivitt, Datenbankverwaltung, Abfrageverwaltung und Business-Intelligence bis hin zur Anwendungsentwicklung.

#The DSDWB strings used on the Unix side only right now. DSDWB_A is used on Windows too.
DSDWB_A=Data Server Developer Tool
DSDWB_B=Data Server Developer Tool ist eine umfassende Suite integrierter Eclipse-Tools fr Datenbankdesigner und Datenbankadministratoren im Entwicklungsbereich. Das Tool reduziert die Zeit, die erforderlich ist, um gespeicherte SQL- und Java-Prozeduren zu erstellen, zu implementieren und zu testen, datenorientierte Web-Services zu implementieren und unter Verwendung von SQL und XQuery fr DB2- und Informix IDS-Datenserver Abfragen fr relationale Daten und XML-Daten zu erstellen.
DSDWB_C=Data Server Developer Tool ist eine umfassende Suite integrierter Eclipse-Tools fr Datenbankdesigner und Datenbankadministratoren im Entwicklungsbereich.
DSDWB_LC=Data Server Developer Tool

#The DSAC strings used on the Unix side only right now. DSAC_A is used on Windows too.
DSAC_A=Data Server Administrator Tool
DSAC_B=Data Server Administrator Tool ist ein Webportaltool, mit dem Datenbankadministratoren eine beliebige Anzahl DB2- und Informix IDS-Datenserver noch effizienter verwalten knnen. Mit Data Server Administrator Tool kann der Betrieb von Datenbankservern auf der erforderlichen Leistungsstufe gehalten werden, indem der zum Beheben von Problemen erforderliche Zeitaufwand reduziert wird und Tasks zur Verwaltung und Wartung von Routinen automatisiert und entfernt werden. Auerdem trgt Data Server Administrator Tool dazu bei, Probleme von vorneherein zu vermeiden.
DSAC_C=Data Server Administrator Tool ist ein Webportaltool, mit dem Datenbankadministratoren eine beliebige Anzahl DB2- und Informix IDS-Datenserver noch effizienter verwalten knnen.
DSAC_LC=Data Server Administrator Tool

UNKNOWN0=IBM DB2
UNKNOWN2=DB2

II0=IBM WebSphere Information Integration
II2=WebSphere Information Integration
II_G=WebSphere Information Integration Version {0}

####################################
# end PRODUCT NAMES & DESCRIPTIONS #
####################################

COPYRIGHT1=Copyright International Business Machines Corporation, 1993, 2006.
COPYRIGHT2=(C) Copyright IBM Deutschland GmbH, 2004. Alle Rechte vorbehalten.

INSTALL_PRODUCT=Produkt installieren

DB2_SETUP=DB2-Installationsprogramm
LANGUAGE=Sprache
RESPONSE_FILE=Antwortdatei
LOG_FILE=Protokolldatei
TRACE_FILE=Tracedatei
PATH_NAME=Installationspfad
COPY_NAME=Name der DB2-Kopie

CLI_SETUP=Installation
CLI_COPY_NAME=Name der IBM Data Server Driver-Kopie

HELP_OPTION=generiert diesen Benutzungshinweis.
C_OPTION=DB2 Setup kehrt umgehend zurck, ohne auf untergeordnete Prozesse zu warten.
F_OPTION=erzwingt das Stoppen von DB2-Prozessen vor der Installation.
I_OPTION=aus zwei Buchstaben bestehender Code fr die bevorzugte Sprache.
L_OPTION=vollstndiger Pfad und Name der Protokolldatei.
M_OPTION=nicht berwachte Installation zeigt einen Fortschrittsanzeiger an, dazu muss die nicht berwachte Installation ausgewhlt sein.
P_OPTION=vollstndiger Pfadname fr das Installationsverzeichnis.
N_OPTION=%s, die von dieser Installation verwendet werden soll.
U_OPTION=vollstndiger Pfad und Name der Antwortdatei.
O_OPTION=startet eine neue Installation mit einem vom System generierten %s.
V_OPTION=verwendet, um Optionen und allgemein zugngliche Merkmale direkt an das Windows-Installationsprogramm zu bergeben.
TRACE_OPTION=erstellt eine Datei mit Trace-Informationen zur Installation.
SMS_OPTION=zwingt diesen Prozess, erst nach Abschluss der Installation zurckzukehren.
W_OPTION=zwingt diesen Prozess, erst nach Abschluss der Installation zurckzukehren.

ERROR_UNSUPPORTED_LOCALE=Nicht untersttzte lnderspezifische Angaben %s.
ERROR_MISSING_LOCALE=Fehlende lnderspezifische Angaben.
ERROR=Das Verzeichnis fr die ausfhrbare Datei wurde nicht gefunden.
ERROR_RETURN_CODE=Rckkehrcode: %d.
ERROR_DIRECTORY_NOT_FOUND=Verzeichnis nicht gefunden: %s.
ERROR_ACCESSING=Fehler beim Zugriff auf '%s'.
ERROR_REQUESTED_LANGUAGE=Die angeforderte Sprache, '%s', ist in diesem DB2-Installationsimage nicht enthalten.
ERROR_LAUNCH=Setup konnte nicht gestartet werden.
ERROR_INSTALL_TRANSFORM=Der Vorgang kann nicht fortgesetzt werden, da die Installationsumsetzung nicht verfgbar ist. 
ERROR_MAXIMUM_COPIES_REACHED=Die maximale Anzahl DB2-Kopien, die auf einem Computer installiert werden kann, ist auf 16 begrenzt. DB2 Setup kann nicht fortgesetzt werden.
ERROR_ANOTHER_SETUP_RUNNING=Eine andere Kopie des DB2-Installationsassistenten ist bereits aktiv. Sie mssen warten, bis der DB2-Installationsassistent beendet ist, bevor Sie fortfahren knnen. Wenn das Problem weiterhin besteht, fhren Sie einen Warmstart des Computers durch und rufen DB2 Setup anschlieend auf.
ERROR_RSP_FILE_INVALID=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. Die Datei ist nicht vorhanden.
ERROR_RSP_FAIL_READ_KEY=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. Der Wert des Schlsselworts '%s' fehlt oder konnte nicht gelesen werden.
ERROR_RSP_KW_NOT_FOUND=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. Das erforderliche Schlsselwort '%s' ist in der Antwortdatei nicht vorhanden.
ERROR_RSP_KW_NO_VALUE=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. Fr das Schlsselwort '%s' fehlt in der Antwortdatei ein Wert.
ERROR_RSP_OPEN_FAILED=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. DB2 Setup kann diese Antwortdatei nicht ffnen oder nicht darauf zugreifen. 
ERROR_RSP_KW_INVALID=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. Das Schlsselwort '%s' in der Antwortdatei ist ungltig.
ERROR_RSP_VALUE_INVALID=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. Das Schlsselwort '%s' hat den ungltigen Wert '%s'.
ERROR_NOMEM=FEHLER: Die zum Durchfhren der aktuellen Aktion erforderliche Speicherkapazitt kann nicht zugeordnet werden. Geben Sie zustzliche Speicherkapazitt frei, und fhren Sie das Installationsprogramm erneut aus. 
ERROR_RSP_INIT_FAILED=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. DB2 Setup kann die Antwortdatei nicht initialisieren.
ERROR_RSP_PROD_NOT_IN=FEHLER: Es ist ein Problem mit der Antwortdatei '%s' aufgetreten. Das Produkt '%s' ist in dieser Installation nicht verfgbar.
ERROR_TRE_CREATE_FAILED=FEHLER: Die Tracedatei '%s' konnte nicht erstellt werden.
ERROR_LAUNCH_TOOLS_INSTALL_FAILED=Das DB2-Installationsprogramm kann die Installation fr %s nicht starten. Wenn das Problem weiterhin auftritt, wenden Sie sich an Ihren Servicebeauftragten.
# {0} in ERROR_BROWSER_NOT_FOUND is replaced with a list of supported browsers.
ERROR_BROWSER_NOT_FOUND=Die Webseite kann nicht angezeigt werden, da kein untersttzter Web-Browser gefunden wurde.\n\nStellen Sie sicher, dass einer der folgenden Browser installiert ist und sich in einem Verzeichnis befindet, das in der Umgebungsvariablen PATH angegeben ist:\n{0}
ERROR_INSTALL_COPY_NAME=FEHLER: Der eingegebene Name der DB2-Kopie ist ungltig. Der Name der DB2-Kopie ist auf 64 Zeichen begrenzt und kann die Zeichen A-Z, a-z und 0-9 enthalten. Das erste Zeichen darf keine Zahl sein.
ERROR_ADMIN_AUTH_REQUIRED=Sie haben keine Berechtigung zum Installieren von %s. Melden Sie sich als Benutzer mit Administratorberechtigung an, und wiederholen Sie den Vorgang.

FONT0=Arial Bold
FONTSIZE0=12

FONT1=Arial Bold
FONTSIZE1=22

FONT2=Arial
FONTSIZE2=8

FONT3=Arial
FONTSIZE3=10

FONT4=Arial
FONTSIZE4=9

FONT5=Arial
FONTSIZE5=6

FONT6=Times New Roman Bold
FONTSIZE6=28

FONT7=Arial
FONTSIZE7=9

FONT8=Arial Bold
FONTSIZE8=12

FONT9=Arial
FONTSIZE9=10

FONT10=Times New Roman
FONTSIZE10=12

JFONT1=TimesNew
JFONTSIZE1=18

JFONT2=TimesNew
JFONTSIZE2=22

JFONT3=TimesNew
JFONTSIZE3=10

JFONT4=Helvetica
JFONTSIZE4=12

JFONT5=Helvetica
JFONTSIZE5=8

JFONT6=Helvetica
JFONTSIZE6=32

JFONT7=Helvetica
JFONTSIZE7=12

JFONT8=TimesNew
JFONTSIZE8=16

JFONT9=Helvetica
JFONTSIZE9=12

JFONT10=TimesNew
JFONTSIZE10=12

IPNEXTBTN=Weiter >
IPBACKBTN=Zurck
IPHELPBTN=Hilfe


IPHEADER=Whlen Sie das zu installierende Produkt aus.

OK=OK
CANCEL=Abbrechen
CONTINUE=Weiter
BROWSE=Durchsuchen
WSASNOTFOUND=Der angegebene Datentrger ist ungltig. Wiederholen Sie die Aktion.
WSASREMOVEPOPUP=Entnehmen Sie die WebSphere-CD, und legen Sie die DB2-CD wieder ein. Klicken Sie 'OK' an, um fortzufahren, 'Durchsuchen', um das DB2-Installationsprogramm manuell zu suchen, oder 'Abbrechen', um den Vorgang abzubrechen.
LOWER_BIT_INSTALL_ERROR=Dieses DB2-Produkt kann nur auf einem Windows-32-Bit-System installiert werden. Klicken Sie '%s' an, um die Installation zu beenden.
HIGHER_BIT_INSTALL_ERROR=Dieses DB2-Produkt kann nur auf einem Windows-64-Bit-System installiert werden. Klicken Sie '%s' an, um die Installation zu beenden.
ERROR_HEADER=Fehler
WARNING_HEADER=Warnung
WARNING_LOGFILE_OVERWRITE=Die angegebene Protokolldatei ist bereits vorhanden. Wenn Sie den Vorgang fortsetzen, wird die vorhandene Protokolldatei berschrieben. Klicken Sie 'Ja' an, um fortzufahren, oder klicken Sie 'Nein' an, um die Installation zu beenden.

IERR_FIXPAK_REF_NOTFOUND=Die Installation ist fehlgeschlagen, da das Fixpack-Image fr das vorhandene DB2-Produkt %s nicht an derselben Speicherposition gefunden werden konnte wie das aktuelle Installationsimage. Stellen Sie sicher, dass sich das Fixpack-Image fr %s in demselben bergeordneten Verzeichnis befindet.
IERR_FIXPAK_REF_MULT_NOTFOUND=Die Installation ist fehlgeschlagen, da nicht alle Fixpack-Images fr die vorhandenen DB2-Produkte %s an derselben Speicherposition gefunden werden konnten wie das aktuelle Installationsimage. Stellen Sie sicher, dass sich die Fixpack-Images fr alle vorhandenen DB2-Produkte in demselben bergeordneten Verzeichnis befinden.

IMSG_PICKER_MAINWINDOW=Mit vorhandener DB2-Kopie arbeiten
# {0} in the string below is replaced with a DB2 product name
IMSG_PICKER_MAINWINDOW_UNIX={0} - Mit vorhandener DB2-Kopie arbeiten
IMSG_PICKER_HEADER=DB2-Kopie zum Arbeiten auswhlen
IMSG_PICKER_UP=Die folgenden DB2-Kopien wurden auf Ihrem Computer festgestellt. Whlen Sie die gewnschte DB2-Kopie und entsprechende auszufhrende Aktion aus.
IMSG_PICKER_CHECKBUTTON=Alle DB2-&Kopien einschlielich jener ohne zutreffende Aktion anzeigen
IMSG_PICKER_LAUNCHBUTTON=DB2-&Installationsassistent starten
IMSG_PICKER_CANCELBUTTON=Abbrechen
IMSG_PICKER_HELPBUTTON=Hilfe
IMSG_PICKER_DITAILS=Details:
IMSG_PICKER_ACTION_NOTAVAILABLE=Nicht verfgbar
IMSG_PICKER_ACTION_UPGRADE=Upgrade durchfhren
IMSG_PICKER_ACTION_INSTALL=Installieren
IMSG_PICKER_ACTION_ADDNEWFUN=Neue Funktion hinzufgen
IMSG_PICKER_ACTION_MIGRATE=Migrieren
IMSG_PICKER_ACTION_DESCRIPTION_NOTAVAILABLE=Es ist keine Aktion verfgbar. Wenn Sie ein Produkt mit einer niedrigeren Codeversion installieren, laden Sie das Installationsimage an der folgenden Speicherposition in der Codeversion herunter, die in dieser DB2-Kopie installiert ist: 
IMSG_PICKER_ACTION_DESCRIPTION_UPGRADE=Fr %s wird durch das Anwenden eines Fixpacks ein Upgrade durchgefhrt. Befinden sich in der ausgewhlten DB2-Kopie mehrere Produkte, ist das Fixpack fr die anderen Produkte zu einem spteren Zeitpunkt erforderlich.
IMSG_PICKER_ACTION_DESCRIPTION_UPGRADE_UNIX_NOSUP=Es ist keine Aktion verfgbar. Wenn Sie in der ausgewhlten DB2-Kopie ein Upgrade fr {0} durchfhren, beenden Sie diese aktuelle Installation, und fhren Sie 'installFixPack' aus.
IMSG_PICKER_ACTION_DESCRIPTION_INSTALL=%s wird in der ausgewhlten DB2-Kopie installiert.
IMSG_PICKER_ACTION_DESCRIPTION_INSTALL_UNIX={0} wird in der ausgewhlten DB2-Kopie installiert.
IMSG_PICKER_ACTION_DESCRIPTION_ADDNEWFUN=Der ausgewhlten DB2-Kopie wird eine neue Funktion hinzugefgt.
IMSG_PICKER_ACTION_DESCRIPTION_ADDPRODUCT=Es ist keine Aktion verfgbar. %s kann nicht installiert werden, weil kein vorausgesetztes DB2-Produkt an dieser Installationsposition installiert ist. Installieren Sie eines der folgenden Produkte, bevor Sie %s installieren: 
IMSG_PICKER_ACTION_DESCRIPTION_MIGRATE=%s wird auf DB2 Version %s migriert. Befinden sich in der ausgewhlten DB2-Kopie mehrere Produkte, werden durch das Migrieren von %s alle anderen Produkte entfernt und die Instanzen und Einstellungen fr diese Kopie migriert. 
IMSG_PICKER_ACTION_DESCRIPTION_UPGRADE32TO64=Fr %s wird ein Upgrade auf DB2 Version %s (64 Bit) durchgefhrt. Befinden sich in der ausgewhlten DB2-Kopie mehrere Produkte, werden durch das Durchfhren eines Upgrades fr %s alle anderen Produkte entfernt, und fr alle Instanzen und Einstellungen wird ein Upgrade durchgefhrt.
IMSG_PICKER_ACTION_DESCRIPTION_MIGRATEVERSION32TO64_NOTAVAILABLE=Die Migration von DB2 Version %s (32 Bit) auf DB2 Version %s (64 Bit) wird nicht untersttzt. Fhren Sie fr die ausgewhlte 32-Bit-DB2-Kopie ein Upgrade auf DB2 Version %s (64 Bit) oder eine Migration auf DB2 Version %s (32 Bit) durch. Fhren Sie die Installation von DB2 Version %s (64 Bit) dann erneut aus.
IMSG_PICKER_ACTION_DESCRIPTION_MIGRATEMULTICOPIES32TO64_NOTAVAILABLE=Es sind mehrere 32-Bit-DB2-Kopien installiert. Die Installation einer 64-Bit-DB2-Kopie ist nur zulssig, wenn sich nur eine 32-Bit-DB2-Kopie auf dem System befindet. Wenn sich Instanzen auf der 32-Bit-DB2-Kopie befinden, mssen Sie sie auf eine einzige 32-Bit-DB2-Kopie versetzen. Deinstallieren Sie anschlieend alle 32-Bit-DB2-Kopien auer der Kopie, auf der sich alle 32-Bit-Instanzen befinden. Nun knnen Sie Ihre DB2 Version %s (64 Bit) installieren.
IMSG_PICKER_ACTION_DESCRIPTION_FIXPACK_NOTAVAILABLE=Sie installieren %s in einer hheren Codeversion. Fhren Sie fr die Produkte in der ausgewhlten DB2-Kopie ein Upgrade auf die Codeversion des Produkts durch, das Sie installieren. Installieren Sie %s anschlieend erneut.
IMSG_PICKER_INSTALLATION_NAME=  Name der DB2-Kopie:
IMSG_PICKER_VERSION_NAME=  Version der DB2-Kopie:
IMSG_PICKER_PRODUCTS_NAME=  Produkte in der DB2-Kopie:
IMSG_PICKER_PATH_NAME=  DB2-Installationspfad:
IMSG_PICKER_ACTION_NAME= Aktion
IMSG_PICKER_DESCRIPTION_NAME=  Aktionsbeschreibung:
IMSG_PICKER_DEFAULT=(Standard)

IMSG_CLIPICKER_MAINWINDOW=Mit vorhandener Kopie arbeiten
IMSG_CLIPICKER_HEADER=Kopie zum Arbeiten auswhlen
IMSG_CLIPICKER_INSTALLATION_NAME=  Produktname:
IMSG_CLIPICKER_PATH_NAME=  Installationspfad:
IMSG_CLIPICKER_LAUNCHBUTTON=&Installationsassistent starten
IMSG_CLIPICKER_CHECKBUTTON=Alle &Kopien einschlielich jener ohne zutreffende Aktion anzeigen
IMSG_CLIPICKER_UP=Die folgenden Kopien wurden auf Ihrem Computer festgestellt. Whlen Sie die gewnschte Kopie und entsprechende auszufhrende Aktion aus.

# new Strings for the Viper launchpad on Unix/Linux
# added by Ryan Chase

#### START OF LAUNCHPAD GROUP ####
# NOTE TO TRANSLATOR: the mnemonics for the buttons below must be different from 
#  each other as they are shown on the same page.

LPAD_BUTTON=Willkommen
LPAD_BUTTON_MNEM=M

NR_INSTALL_BUTTON=Informationen zu nicht als Root ausgefhrten Installationen
NR_INSTALL_BUTTON_MNEM=N

INSTALL_PREREQS_BUTTON=Vorbedingungen
INSTALL_PREREQS_BUTTON_MNEM=I

RELNOTES_BUTTON=Release-Informationen
RELNOTES_BUTTON_MNEM=R

MIGRATION_BUTTON=Informationen zur Migration
MIGRATION_BUTTON_MNEM=M

INSTALL_BUTTON=Produkt installieren
INSTALL_BUTTON_MNEM=P

EXISTING_BUTTON1=Mit vorhandener Installation arbeiten
#EXISTING_BUTTON1_MNEM=E
EXISTING_BUTTON2=Vorhandenes aktualisieren
EXISTING_BUTTON2_MNEM=V

INSTALLNEW_BUTTON=Neue Installation
#INSTALLNEW_BUTTON_MNEM=w

INSTALL_EXTERNAL_BUTTON =Installieren
#INSTALL_EXTERNAL_BUTTON_MNEM=l

EXIT_BUTTON=Beenden
EXIT_BUTTON_MNEM=X

#                              #
#### END OF LAUNCHPAD GROUP ####

IMSG_PICKER_UNIX_LAUNCHBUTTON=DB2-Installationsassistenten starten
IMSG_PICKER_UNIX_LAUNCHBUTTON_MNEM=L

LPAD_WELCOME_TITLE=Willkommen {0}
LPAD_WELCOME_TITLE_DB2=Willkommen {0} bei DB2 Version {1}
LAPD_WELCOME_TITLE_IBM_DATA_SERVER=Willkommen {0} bei IBM Data Server Version {1}

# LPAD_WELCOME_DESC1 and LPAD_WELCOME_DESC2 are shown on the welcome page of the Launchpad, one after the other.
LPAD_WELCOME_DESC1=Mit 'DB2 Setup - Launchpad' knnen Sie auf alle Informationen zugreifen, die Sie fr die Installation Ihrer DB2-Produkte und -Funktionen fr die Betriebssysteme Linux, UNIX und Windows bentigen.
LPAD_WELCOME_DESC2=Whlen Sie eine relevante Indexzunge aus, um auf weitere Informationen zu den DB2-Produkten zuzugreifen, die installiert werden knnen, oder um eine Installation auszufhren. 
LPAD_WELCOME_DESC3=Sie knnen weitere Produktinformationen abrufen, indem Sie die Informationszentrale durchsuchen.
LPAD_WELCOME_SEARCH_IC=Informationszentrale durchsuchen

LPAD_NR_INSTALL_TITLE=Informationen zu nicht als Root ausgefhrten Installationen
LPAD_NR_INSTALL_DESC1=Sie fhren das DB2-Installationsprogramm nicht als Root aus. Informationen zum Installieren, wenn Sie nicht als Root angemeldet sind, finden Sie in den untenstehenden Themen. 
LPAD_NR_INSTALL_LINK_OVERVIEW=bersicht zu nicht als Root ausgefhrter Installation
LPAD_NR_INSTALL_LINK_REQTS=Voraussetzungen fr nicht als Root ausgefhrte Installationen
LPAD_NR_INSTALL_LINK_LIMIT=Einschrnkungen einer nicht als Root ausgefhrten Installation

LPAD_PREREQS_TITLE=Vorbedingungen
LPAD_PREREQS_DESC1=Stellen Sie vor dem Installieren Ihres DB2-Produkts sicher, dass Ihr System alle Installationsvoraussetzungen einschlielich Betriebssystemkorrekturen erfllt. Hierdurch vermeiden Sie eventuelle technische Probleme whrend oder nach der Installation und Konfiguration der einzelnen Produkte.
LPAD_PREREQS_LINK_INFO=Informationen zu DB2-Voraussetzungen
LPAD_PREREQS_LINK_REQTS=Platten- und Speichervoraussetzungen von DB2
LPAD_PREREQS_NRINSTINFO=Klicken Sie {0} an, um die Voraussetzungen fr nicht als Root ausgefhrte Installationen anzuzeigen.

LPAD_RELNOTES_TITLE=Release-Informationen
LPAD_RELNOTES_DESC1=Aktuelle Produktinformationen finden Sie in den Themen der Release-Informationen.
LPAD_RELNOTES_LINK=Release-Informationen
LPAD_RELNOTES_NEW_DESC=Informationen zu neuen Funktionen, die mit diesem Release zur Verfgung stehen, finden Sie in den Themen unter 'Neue Funktionen'.
LPAD_RELNOTES_NEW_LINK=Neue Funktionen
LPAD_RELNOTES_CHANGED_DESC=Details zu genderten, veralteten oder eingestellten Funktionen von Version {0} finden Sie in den Themen unter 'nderungen'.
LPAD_RELNOTES_CHANGED_LINK=nderungen

LPAD_MIGR_TITLE=Informationen zur Migration
LPAD_MIGR_DESC1=Einzelheiten zum Migrieren auf dieses DB2-Release von einem Vorgngerrelease oder von einem anderen Datenbankprodukt finden Sie in den Informationen zur Migration.
LPAD_MIGR_LINK=Einfhrung in die DB2-Migration

LPAD_INSTALL_TITLE=Produkt als {0} installieren
LPAD_INSTALL_DESC1=Klicken Sie 'Neue Installation' an, um den DB2-Installationsassistenten fr das gewnschte Produkt zu starten und das Produkt an einer neuen Speicherposition zu installieren.
LPAD_INSTALL_DESC2=Wenn Sie einem vorhandenen Produkt Funktionen hinzufgen wollen, klicken Sie 'Vorhandenes aktualisieren' an.
LPAD_INSTALL_DESC3=Wenn Sie einem vorhandenen Produkt Funktionen hinzufgen wollen, klicken Sie 'Mit vorhandener Installation arbeiten' an.
#LPAD_INSTALL_DESC4 is shown in combination with one or more of the above sentences.
LPAD_INSTALL_DESC4=Sie knnen auch weitere Produktinstallationen starten, indem Sie fr das jeweilige Produkt 'Installieren' anklicken.

WARNING_MIGRATION_HEADER=Die Migration wendet nderungen auf Ihre DB2-Kopie an. Einige dieser nderungen erfordern mglicherweise die Ausfhrung folgender Tasks vor oder nach der Migration:
WARNING_NEED_TO_RUN_DB2CKMIG=1. Die vorhandenen lokalen Datenbanken mssen nach der Installation von %s migriert werden, um mit %s verwendet werden zu knnen. Der Befehl 'db2ckmig' prft auf Bedingungen, die die erfolgreiche Migration der lokalen Datenbanken verhindern knnten. Vor der Installation von %s muss der Befehl 'db2ckmig' mit Ihrer zurzeit installierten DB2-Version ausgefhrt werden. Nach der Installation von %s ist ein berprfen Ihrer Datenbanken mit diesem Befehl nicht mglich. Der Befehl 'db2ckmig' befindet sich im Verzeichnis %s auf den Installationsmedien. 
WARNING_UNINSTALL_PRODUCTS=2. Alle zuvor in der zu migrierenden DB2-Kopie %s vorhandenen DB2-Produkte werden entfernt. Bei der Migration wird eine Kopie von %s installiert. Andere DB2-Produkte als %s mssen im Anschluss an die Migration separat installiert werden.
WARNING_CONTINUE=Klicken Sie zum Fortfahren 'OK' an. Oder klicken Sie 'Abbrechen' an, um das DB2-Installationsprogramm zu beenden und zu prfen, ob Ihre DB2-Kopie %s fr die Migration bereit ist. 
MIGRATION_REMOVING_DB2=Das alte DB2-Produkt bzw. die alten DB2-Produkte werden entfernt. Bitte warten.

NO_VALID_PROD_IDENTIFIER=Das Produktimage verfgt ber keine gltige Kennung fr das Installationsprogramm, um die verfgbaren Optionen anzuzeigen. Das Produktimage wurde modifiziert. Fhren Sie die Installation mit Hilfe des ursprnglichen DB2-Produktimages aus.

# the below messages for InstallLauncher Only
IMSG_LAUNCHER_ERROR_COPYPATH=Das angegebene Installationsverzeichnis "%s" ist ungltig.
IMSG_LAUNCHER_ERROR_UNKNOWN_PARAM=Mindestens ein Parameter ist ungltig.
IMSG_LAUNCHER_INSTALLTYPE_WARNING=Durch das Ausfhren des Setups wird die Verwaltung oder die Upgradeinstallation von %s - %s ausgefhrt. Wenn Sie eine neue Kopie von IBM Data Server Driver installieren mchten, fhren Sie das Setup mit der Option /o oder /n <name_der_kopie> aus. Wollen Sie fortfahren?
IMSG_LAUNCHER_COPYNAME_PATH_CONFLICT=Der angegebene Name der Kopie stimmt nicht mit der angegebenen Installationsposition berein. Stellen Sie sicher, dass der Name der Kopie mit der Installationsposition bereinstimmt.
  

# the below message is for non-root install only
IMSG_NR_INSTALL_NOT_SAME_AS_IMAGE=Die Version Ihrer bereits installierten DB2-Produkte stimmt nicht mit der Version des Produkts berein, das Sie fr die Installation ausgewhlt haben. Wenn Sie ein Produkt mit einer niedrigeren Codeversion installieren, laden Sie das Installationsimage in der Codeversion herunter, ber die auch die DB2-Produkte verfgen, die Sie bereits installiert haben. Wenn Sie ein Produkt in einer hheren Codeversion installieren, mssen Sie zunchst den Befehl installFixPack ausfhren, um ein Upgrade fr Ihre bereits installierten DB2-Produkte durchzufhren.

# the below message shows up before installing VSAI's ProjectAggregator2.msi
INSTALL_PROJECTAGGREGATOR2=Wir installieren Microsoft Visual Studio ProjectAggregator2. Dies ist erforderlich, um das Debugging gespeicherter SQL-Prozeduren ber CLR-Anwendungen zu untersttzen. Diese Komponente kann gemeinsam mit anderen Visual Studio-Erweiterungen genutzt werden. Sie sollte nur deinstalliert werden, wenn auch die IBM Database-Add-ins fr Visual Studio 2005 deinstalliert werden. Es ist mglicherweise nicht sicher, die Komponente zu deinstallieren, wenn sie auch von anderen Visual Studio-Erweiterungen verwendet wird. Diese Komponente wird in nicht interaktiven Installationen nicht installiert.

# This is temporary. This string should really go into miscstrwi.txt, but we don't have another MRI shipment for miscstrwi.txt until Cobra
WI_MSG_DISK_SIZE=Plattengre
