# --------------------------------------------------------------------------------------
#
#  IBM CONFIDENTIAL
#  OCO SOURCE MATERIALS
#
#  COPYRIGHT:  P#2 P#1
#              COPYRIGHT IBM CORPORATION Y1, Y2
#
#  The source code for this program is not published or otherwise divested of
#  its trade secrets, irrespective of what has been deposited with the U.S.
#  Copyright Office.
#
#  Source File Name = (%W%)
#
#  Descriptive Name = Strings for the graphical components of our install
#
#  Function: Map string tokens to values.
#            NLS enablement.
#
#  Dependencies: See import list.
#
#  Restrictions:
#
#  Change Activity:
#  DATE        DESCRIPTION                                             S&D Code
#  ==============================================================================
#  2002/05/13  add this header and special tokens for Java             @d230924rac
#  2002/11/07  add mnemonic for launchpad buttons                      @d254190gyx
#  2002/12/03  update prod names/descriptions for RCON/LSDC (II)       @d262416rac
#  2002/12/28  update copyright info                                   @d263188rac
#  2002/12/30  add prod name/description for Aurora aka cube aka mmm   @d264987rac
#  2002/12/30  add prod name/description for Express                   @d275660rac
#  2003/07/17  update prod description for ese                         @d223246gyx
#  2003/10/21  add prod name/description for Information Center DOCE   @d296504rbv
#  2003/11/08  new V82 launchpad gif image, some strings not needed    @d297739gaf
#  2003/11/12  modify string for launchpad                             @d299782aab
#  2003/11/13  keep all strings, change code for strings not needed    @d300021gaf
#  2003/11/26  add finalized DOCE strings                              @d301757rbv
#  2003/11/27  add DB2UDB key                                          @d299962rbv
#  2004/01/28  modify font sizes                                       @d304784aab
#  2004/01/29  add short product names                                 @d308413aab
#  2004/03/30  windows specific windows names (without mnemonic)       @d319806gaf
#  2004/10/14  added new command line option help /p /c /m             @d351484djp
#  2005/04/01  added initial choice for NLPACK strings                 @w028116hab
#  2005/06/13  adding NLPACK3 description text                         @w036186hab
#  2005/06/15  remove strings related to DLM product                   @w036510hab
#  2005/06/24  added strings for launch.C                              @w036438rya
#  2005/07/06  remove references to DOCS                               @w035675hab
#  2005/07/18  modify ERROR_RSP_* strings                              @w039116rya
#  2005/08/15  add strings for the Picker                              @w041118iz
#  2005/09/01  modify strings for the Picker                           @w046053iz
#  ==============================================================================
#
#  Last Changed = %E% %U%
#
#  --------------------------------------------------------------------------------------
#  Version:  %I%, %G%
#  --------------------------------------------------------------------------------------
#
# NOTES TO TRANSLATORS:
# *********************
#
#    Translatable entries in this file have the form: 
#        STRING_KEY = text value
#    An example is:
#        D391BP_DISP_NONE = None
#
# 1. The first part, the key, is usually uppercased, and is not translated.
#    This is the name of the entry used in the Java code.
#
# 2. The second part is the value of the entry. This is the text that is
#    translated and used at run time.
#
# The pound sign (#) is a comment marker. For a literal #, write \u0023.
#
# Keys that begin with the forward slash (ie "/") are special tokens 
# and should NOT be translated
#
# The folloing is needed to make sure this file will pass the CHKPII check (for
# translation).
# NLS_MESSAGEFORMAT_NONE
#
#====================================================================
# This file is for the language: en_US
# start of special tokens, do not translate
/PACKAGE_NAME = com.ibm.db2.install.resources
/MNEMONIC_SUFFIX = _MNEM
/ACCELERATOR_SUFFIX = _ACCEL
/BASE
# end of special tokens
#====================================================================

INTRO=DB2:n aloitusohjelman lataus on meneilln.

TITLE=IBM DB2:n asennuksen aloitusohjelma
TITLE_BRAND=Tiedonhallintaohjelmisto
VERSION=Versio {0}

##################################
# PRODUCT NAMES and DESCRIPTIONS #
##################################

# SERVER

SERVER0=DB2-palvelin
SERVER2=DB2-palvelin

# VSAI 

VSAI0=IBM Database Add-Ins for Visual Studio 2005
VSAI2=IBM Database Add-Ins for Visual Studio 2005

# DSDRIVER

DSDRIVER0=IBM Data Server for ODBC, CLI, and .NET
DSDRIVER2=IBM Data Server for ODBC, CLI, and .NET

# servers/database engines

ESE0=IBM DB2 Enterprise Server Edition
ESE2=DB2 Enterprise Server Edition
#the <prod_abbr>_G is used by the java gui Product.java for the use by the Launchpad 
ESE_G=DB2 Enterprise Server Edition -ohjelmiston versio {0}
ESE3=DB2 Enterprise Server Edition -ohjelmisto on suunniteltu keskisuurten ja suurten yritysten tietopalvelintarpeita varten. Se voidaan asentaa yhden tai usean suorittimen Linux-, UNIX- tai Windows-palvelimeen.\n\nDB2 Enterprise Server Edition -ohjelmisto on erinomainen perusta yrityksen on-demand-ratkaisuille, kuten useiden teratavujen kokoisille tietovarastoratkaisuille tai erittin suorituskykyisille korkean kytettvyyden (24x7) tapahtumanksittely- ja verkkoratkaisuille.  DB2 Enterprise Server Edition sislt aidon XML-tietovaraston, jonka XML-tietoja voi ksitell XQuery-, XPath- ja SQL-kielell sek tavallisilla raportointitykaluilla.\n\nDB2 Enterprise Server Edition -ohjelmistoon on saatavilla lisominaisuuksia esimerkiksi seuraaville alueille: tietokantojen osiointi, suorituskyky, tietosuoja, tietojen hajautus ja tietokannan hallinta.  Listietoja on osoitteessa http://www.ibm.com/db2.
ESE4=DB2 Enterprise Server Edition -ohjelmisto on suunniteltu keskisuurten ja suurten yritysten tietopalvelintarpeita varten.

WSE0=IBM DB2 Workgroup Server Edition
WSE2=DB2 Workgroup Server Edition
WSE_G=DB2 Workgroup Server Edition -ohjelmiston versio {0}
WSE3=DB2 Workgroup Server Edition -ohjelmisto on suunniteltu tyryhmien ja keskisuurten yritysten tarpeita varten.  DB2 Workgroup Server Edition sislt aidon XML-tietovaraston, jonka XML-tietoja voi ksitell XQuery-, XPath- ja SQL-kielell sek tavallisilla raportointitykaluilla.\n\nDB2 Workgroup Server Edition -ohjelmistoon on saatavilla lisominaisuuksia esimerkiksi seuraaville alueille: suorituskyky, korkea kytettvyys, kuormituksen hallinta ja tietojen hajautus.  Listietoja on osoitteessa http://www.ibm.com/db2.
WSE4=DB2 Workgroup Server Edition -ohjelmisto on suunniteltu tyryhmien ja keskisuurten yritysten tarpeita varten.

EXP0=IBM DB2 Express Edition
EXP2=DB2 Express
EXP_G=DB2 Express -ohjelmiston versio {0}
EXP3=DB2 Express Edition -ohjelmisto sislt kaikki DB2-tietopalvelimen toiminnot, ja se on suunnattu pienille ja keskisuurille yrityksille.  Ohjelmisto toimitetaan helposti asennettavassa pakkauksessa. Se on saatavana Linux-ja Windows-ympristn. Se on tysin yhteensopiva muiden DB2-tuoteperheen ohjelmistojen kanssa ja se sislt kaikki niihin kuuluvat autonomisen hallinnan ominaisuudet. DB2 Express sislt aidon XML-tietovaraston, jonka XML-tietoja voi ksitell XQuery-, XPath- ja SQL-kielell sek tavallisilla raportointitykaluilla.\n\nDB2 Express -ohjelmistoon on saatavilla lisominaisuuksia esimerkiksi seuraaville alueille: suorituskyky, kuormituksen hallinta ja tietojen hajautus.  Listietoja on osoitteessa http://www.ibm.com/db2.
EXP4= DB2 Express Edition -ohjelmisto sislt kaikki DB2-tietopalvelimen toiminnot, ja se on suunnattu pienille ja keskisuurille yrityksille.


PE0=IBM DB2 Personal Edition
PE2=DB2 Personal Edition
PE_G=DB2 Personal Edition -ohjelmiston versio {0}
PE3=DB2 Personal Edition -ohjelmisto on toisinnuksella varustettu yhden kyttjn tysitoimintoinen relaatiotietokantaohjelmisto, joka soveltuu hyvin palvelimettomaan PC-kyttn.  DB2 Personal Edition -ohjelmistoa voidaan ethallita, joten se sopii hyvin satunnaiseen tai etkyttn, jossa ei tarvita ohjelmiston monikyttjominaisuuksia.  DB2 Personal Edition -ohjelmisto voidaan asentaa Linux- tai Windows-jrjestelmn, jonka saapuvat tietokantayhteydet rajoitetaan vain hallintakytt varten.\n\nListietoja on osoitteessa http://www.ibm.com/db2.
PE4=DB2 Personal Edition -ohjelmisto on toisinnuksella varustettu yhden kyttjn relaatiotietokantaohjelmisto, joka soveltuu hyvin palvelimettomaan PC-kyttn.

# connects

CONEE0=IBM DB2 Connect Server
CONEE2=DB2 Connect Server
CONEE_G=DB2 Connect Server -tuotteen versio {0}
CONEE3=DB2 Connect Server -tuotteet on suunniteltu yrityksille, jotka tarvitsevat monipuolisia yhteyksi typytjrjestelmist suurkone- ja iSeries-jrjestelmiss oleviin tietokantapalvelimiin.  Nm tuotteet on suunniteltu kolmetasoista ymprist varten, jossa DB2-sovellustyasemat muodostavat yhteyden palvelimissa oleviin tietokantoihin DB2 Connect Server -ohjelman avulla.  DB2 Connect -tuotteet sisltvt PC:hen asennettavat DB2-tyasemaohjelman ja API-ajurit, joiden avulla PC:n tyasema-palvelin-sovellukset muodostavat yhteyden DB2 Connect Server -palvelimeen.  DB2 Connect Server -ohjelma hydynt yhteysvarantoja ja yhteyksien keskitystoimintoja sek minimoi keskuskoneen resurssien kytt siten, ett tyasema-palvelin-sovellukset saavat yhteyden palvelimeen vaativissakin ympristiss. \n\nDB2 Connect Server -tuotteet ovat saatavana erilaisina painoksina, joilla on erilaiset lisensointiehdot ja jakelumallit.  Listietoja on osoitteessa http://www.ibm.com/db2.
CONEE4=DB2 Connect Server -tuotteet on suunniteltu yrityksille, jotka tarvitsevat monipuolisia yhteyksi typytjrjestelmist suurkone- ja iSeries-jrjestelmiss oleviin tietokantapalvelimiin.

CONPE0=IBM DB2 Connect Personal Edition
CONPE2=DB2 Connect Personal Edition
CONPE_G=DB2 Connect Personal Edition -ohjelmiston versio {0}
CONPE3=DB2 Connect Personal Edition sislt API-ajurit ja yhteysinfrastruktuurin suoran yhteyden muodostamista varten Windows- ja Linux-typytsovelluksista keskuskone- ja iSeries-tietokantapalvelimiin. Tm tuote on suunniteltu ja lisensoitu erityisesti erillisiss tyasemissa ajettaville kaksitasoisille tyasema-palvelin-sovelluksille eik sit voi kytt palvelimissa.\n\nPinvastoin kuin DB2 Connect Server -tuotteissa DB2 Connect Personal Edition -ohjelmistossa ei ole lisominaisuuksia, kuten hajautettujen tietokantojen tukea, palvelinperustaisia valvonta- tai yhteyksien keskitys- ja kuormituksen tasaus- tai hiritilanteiden ksittelytoimintoja.  Listietoja on osoitteessa http://www.ibm.com/db2.
CONPE4=DB2 Connect Personal Edition sislt API-ajurit ja yhteysinfrastruktuurin suoran yhteyden muodostamista varten Windows- ja Linux-typytsovelluksista keskuskone- ja iSeries-tietokantapalvelimiin.

# clients

CLIENT0=IBM Data Server Client
CLIENT2=IBM Data Server Client
CLIENT_G=IBM Data Server Client -tyasemaohjelmiston versio {0}
CLIENT3=IBM Data Server Client -tyasemaohjelmisto sislt tykaluja ja osia, joiden graafisten ja tekstipohjaisten kyttliittymien avulla voi hallita DB2-tuotteita ja kehitt DB2-tuotesovelluksia.  Ohjelmisto sislt lisosat Eclipse- ja Microsoft Visual Studio 2005 -kehitysympristn.\n\nIBM Data Server Client -tyasemaohjelmisto sisltyy tuotteisiin DB2 Server, DB2 Express, DB2 Connect Server ja DB2 Connect Personal Edition.  Listietoja on osoitteessa http://www.ibm.com/db2.
CLIENT4=IBM Data Server Client -tyasemaohjelmisto sislt tykaluja ja osia, joiden graafisten ja tekstipohjaisten kyttliittymien avulla voi hallita DB2-tuotteita ja kehitt DB2-tuotesovelluksia.

RTCL0=IBM Data Server Runtime Client
RTCL2=IBM Data Server Runtime Client
RTCL_G=IBM Data Server Runtime Client -tyasemaohjelman versio {0}
RTCL3=IBM Data Server Runtime Client -ohjelmisto kevytrakenteinen tekstipohjainen tyasemaohjelma, jonka avulla sovellukset voivat kytt DB2-palvelimia.  Se sislt tuen seuraavia rajapintoja kyttville sovelluksille: SQL, CLI, JDBC, SQLJ, ODBC, OLE DB, .NET ja PHP.\n\nIBM Data Server Runtime Client -tyasemaohjelma sisltyy tuotteisiin DB2 Server, DB2 Express, DB2 Connect Server ja DB2 Connect Personal Edition.  Listietoja on osoitteessa http://www.ibm.com/db2.
RTCL4=IBM Data Server Runtime Client -ohjelmisto kevytrakenteinen tekstipohjainen tyasemaohjelma, jonka avulla sovellukset voivat kytt DB2-palvelimia.

# add on products

LSDC0=IBM WebSphere Information Integration Nonrelational Wrappers
LSDC2=WebSphere Information Integration Nonrelational Wrappers
LSDC_G=WebSphere Information Integration Nonrelational Wrappers -ohjelmiston versio {0}
LSDC3=WebSphere Information Integration Nonrelational Wrappers -ohjelmisto mahdollistaa WebSphere Information Integration -jrjestelmn tarjoaman genetiikkaan, kemiaan, biologiaan ja muuhun tutkimukseen liittyvien tietojen yhdistmisen biotieteellisist tietolhteist. \n\nListietoja on osoitteessa http://www.ibm.com/software/data/integration/federation_server/.
LSDC4=WebSphere Information Integration Nonrelational Wrappers -ohjelman avulla voi muodostaa yhteyden muihin kuin relaatiotietolhteisiin.

RCON0=IBM WebSphere Information Integration Relational Wrappers
RCON2=WebSphere Information Integration Relational Wrappers
RCON_G=WebSphere Information Integration Relational Wrappers -ohjelmiston versio {0}
RCON3=WebSphere Information Integration Relational Wrappers -ohjelman avulla voit tehd kyselyit ja noutaa tietoja hajautetuista DB2- ja muista kuin DB2-relaatiotietokannoista.  Yksi SQL-ksky voi viivata yhteen tai useaan tietokantaan. Voit esimerkiksi liitostaa DB2-taulukon ja Oracle-taulukon tiedot Microsoft SQL Server -nkymst noudettuihin tietoihin.\n\nListietoja on osoitteessa http://www.ibm.com/software/data/integration/federation_server/.
RCON4=WebSphere Information Integration Relational Wrappers -ohjelman avulla voi ksitell muussa kuin IBM-tietolhteess olevia tietoja.

QP0=IBM DB2 Query Patroller
QP2=DB2 Query Patroller
QP_G=DB2 Query Patroller -ohjelman versio {0}
QP3=DB2 Query Patroller on kyselyjen tykuorman hallintaohjelmisto, joka st DB2-tietokannan kuormitusta ohjaamalla kyselyjen lhetyst ja toteusta ennakoivasti ja ajonaikaisesti. \n\nSe on saatavana lisominaisuutena tuotteisiin DB2 Enterprise Server Edition, DB2 Workgoup Server Edition ja DB2 Express Edition.  Listietoja on osoitteessa http://www.ibm.com/db2.
QP4=DB2 Query Patroller on kyselyjen tykuorman hallintaohjelmisto, joka st DB2-tietokannan kuormitusta ohjaamalla kyselyjen lhetyst ja toteusta ennakoivasti ja ajonaikaisesti.

GSE0=IBM DB2 Spatial Extender
GSE2=DB2 Spatial Extender
GSE_G=DB2 Spatial Extender -ohjelman versio {0}
GSE3=DB2 Spatial Extender -ohjelmisto hydynt relaatiotietokantamallia paikkatietojen tallennukseen, ksittelyyn, hallintaan ja analysointiin.  DB2 Spatial Extender -ohjelmisto kytt paikkatietolajeille ja -toiminnoille SQL-kielt samalla tavalla kuin muillekin tietolajeille. DB2 Spatial Extender -ohjelmisto toimitetaan veloituksetta tiettyjen DB2 Server -tuotteiden mukana.\n\nListietoja on osoitteessa http://www.ibm.com/software/data/spatial/.\n\nDB2 Geodetic Data Management -lisominaisuus, joka toimii DB2 Spatial Extender -ohjelmiston kanssa, tukee ksittelee paikkatiedot siten, ett kartta on kolmiulotteinen pallo. Sen avulla business intelligence -sovellusten ja muiden paikkatietoja analysoivien sovellusten kehittminen on helpompaa.  DB2 Geodetic Extender -ohjelmisto voi mallintaa virtuaalisen maapallon miss mittakaavassa tahansa. Useimmat paikkatiedot kertn kyttmll maailmanlaajuisia GPS-jrjestelmi ja tiedot esitetn pituus- ja leveyspiirikoordinaatteina.  DB2 Geodetic Data Management -lisominaisuus on saatavana DB2 Enterprise Server Edition -ohjelmiston valinnaisena osana.\n\nListietoja on osoitteessa http://www.ibm.com/software/data/spatial/db2geodetic/.
GSE4=DB2 Spatial Extender -ohjelman avulla voit tallentaa, hallita ja analysoida DB2 Server -tuotteisiin tallennettuja paikkatietoja.

NLPACK0=IBM DB2:n liskieliversioiden asennusohjelma
NLPACK2=DB2:n liskieliversioiden asennusohjelma
NLPACK_G=DB2:n liskieliversioiden asennusohjelman versio {0}
NLPACK3=DB2:n liskieliversioiden asennusohjelma lis kansallisten kielten tuen DB2-tuotteisiin. DB2-tuotteet voi lokalisoida milloin tahansa lismll kielituen.
NLPACK4=DB2:n liskieliversioiden asennusohjelma lis kansallisten kielten tuen DB2-tuotteisiin. DB2-tuotteet voi lokalisoida milloin tahansa lismll kielituen.

# IC and other weirdos

DOCE0=IBM DB2 Opastus
DOCE2=DB2 Opastus
DOCE_G=DB2 Opastuksen versio {0}
DOCE3=DB2 Opastus sislt tietoja DB2-tuotteista. Siin ksitelln kaikki DB2:n ominaisuudet kyttnotosta tietokantayhteyksiin, tietokannan hallintaan, kyselyjen hallintaan, business intelligence -tykaluihin ja sovelluskehitykseen. DB2 Opastuksessa on hakutoiminto, jonka avulla tarvittavat tiedot DB2-tuotteiden ominaisuuksista lytyvt nopeasti.\n\nOhjatun DB2-ohjelmiston asennustoiminnon avulla voit asentaa DB2 Opastuksen paikalliseksi omaan tietokoneeseen DB2-ohjelmiston asennuksen yhteydess.  Jos tietokone, johon DB2 Opastus on asennettu, on liitetty verkkoon, muut kyttjt voivat kytt DB2 Opastusta selaimen avulla. Nin DB2-tuotteet voivat kytt yhteist DB2 Opastusta verkossa joko tietokoneesta, johon se on asennettu, tai IBM:n Web-sivustosta.\n\nDB2 Opastuksen pivityksi on aika ajoin saatavilla.  Jos haluat kyttjien kyttvn viimeisimpi tietoja, sinun ei tarvitse ladata pivityksi verkkoon, vaan voit mritt DB2-tuotteet siten, ett ne kyttvt IBM:n Web-sivustossa olevaa DB2 Opastusta. Tm IBM:n Web-sivustossa oleva DB2 Opastuksen versio pivitetn aina tarvittaessa DB2-ohjelmiston viimeisint versiota vastaavaksi.
DOCE4=DB2 Opastus sislt tietoja DB2-tuotteista. Siin ksitelln kaikki DB2:n ominaisuudet kyttnotosta tietokantayhteyksiin, tietokannan hallintaan, kyselyjen hallintaan, business intelligence -tykaluihin ja sovelluskehitykseen.

#The DSDWB strings used on the Unix side only right now. DSDWB_A is used on Windows too.
DSDWB_A=Data server developer tool
DSDWB_B=Data server developer tool on Eclipse-tykaluja sisltv kattava ohjelmisto tietokantasuunnittelijoita ja sovelluskehittji varten. Tykaluohjelmisto vhent tallennettujen SQL- ja Java-toimintosarjojen luonti-, kyttnotto- ja vianmritysaikaa, tietokeskeisten Web-palveluiden kyttnottoaikaa sek SQL- ja XQuery for DB2 and Informix IDS -tietokantapalvelimien avulla tapahtuvien relaatio- ja XML-tietojen kyselyiden luontiaikaa.
DSDWB_C=Data server developer tool on Eclipse-tykaluja sisltv kattava ohjelmisto tietokantasuunnittelijoita ja sovelluskehittji varten.
DSDWB_LC=data server developer tool

#The DSAC strings used on the Unix side only right now. DSAC_A is used on Windows too.
DSAC_A=Data server administrator tool
DSAC_B=Data server administrator tool on Web-portaalitykalu, jonka avulla tietokannan pkyttjt voivat hallita yht tai useita DB2- ja Informix IDS -tietokantapalvelimia tehokkaasti. Data server administrator tool -ohjelmisto auttaa pitmn tietokantapalvelimet tarvittavalla suorituskykytasolla, sill ohjelmisto vhent ongelmien ratkaisuun kuluvaa aikaa ja sen avulla voidaan automatisoida ja poistaa rutiininomaisia yllpito- ja huoltotehtvi sek vltt lopulta ongelmat kokonaan.
DSAC_C=Data server administrator tool on Web-portaalitykalu, jonka avulla tietokannan pkyttjt voivat hallita yht tai useita DB2- ja Informix IDS -tietokantapalvelimia tehokkaasti.
DSAC_LC=data server administrator tool

UNKNOWN0=IBM DB2
UNKNOWN2=DB2

II0=IBM WebSphere Information Integration
II2=WebSphere Information Integration
II_G=WebSphere Information Integration -ohjelmiston versio {0}

####################################
# end PRODUCT NAMES & DESCRIPTIONS #
####################################

COPYRIGHT1=Copyright International Business Machines Corporation, 1993, 2006.
COPYRIGHT2=Kaikki oikeudet pidtetn.

INSTALL_PRODUCT=Ohjelman asennus

DB2_SETUP=DB2:n asennusohjelma
LANGUAGE=kieli
RESPONSE_FILE=vastaustiedosto
LOG_FILE=lokitiedosto
TRACE_FILE=jljitystiedosto
PATH_NAME=asennuspolku
COPY_NAME=DB2-kopion nimi

CLI_SETUP=Asennus
CLI_COPY_NAME=IBM-tietokantapalvelimen ajurin kopion nimi

HELP_OPTION=tuo kuvaruutuun tmn sanoman.
C_OPTION=DB2-ohjelmiston asennustoiminto palaa kuvaruutuun odottamatta aliohjelmien pttymist.
F_OPTION=toteuttaa DB2-prosessien pakkolopetuksen ennen asennusta.
I_OPTION=halutun kielen kaksimerkkinen koodi.
L_OPTION=lokitiedoston tydellinen saantipolku ja nimi.
M_OPTION=hiljaisessa asennuksessa kuvaruutuun tulee tilannerivi, jos hiljainen asennus on valittu.
P_OPTION=asennushakemiston tydellinen saantipolku.
N_OPTION=tss asennuksessa kytettv %s.
U_OPTION=vastaustiedoston tydellinen saantipolku ja nimi.
O_OPTION=aloittaa uuden asennuksen kyttmll jrjestelmn luomaa kohdetta %s.
V_OPTION=jota kytetn valintojen ja julkisten ominaisuuksien siirtoon suoraan Windowsin asennusohjelmaan.
TRACE_OPTION=luo asennuksen jljitystiedot sisltvn tiedoston.
SMS_OPTION=pakottaa tmn prosessin jatkumaan, kunnes asennus on valmis.
W_OPTION=pakottaa tmn prosessin jatkumaan, kunnes asennus on valmis.

ERROR_UNSUPPORTED_LOCALE=Jrjestelm ei tue paikalliskuvausta %s.
ERROR_MISSING_LOCALE=Paikalliskuvaus puuttuu.
ERROR=Ajettavan tiedoston nimen nouto ei onnistu. Hakemistoa ei lydy.
ERROR_RETURN_CODE=Paluukoodi on %d.
ERROR_DIRECTORY_NOT_FOUND=Hakemistoa %s ei lydy.
ERROR_ACCESSING=Kohteen '%s' kytt ei onnistu.
ERROR_REQUESTED_LANGUAGE=Mritetty kieli '%s' ei sislly thn DB2-asennustiedostoon.
ERROR_LAUNCH=Asennusohjelman aloitus ei onnistu.
ERROR_INSTALL_TRANSFORM=Jatko ei onnistu, asennuksen muunto ei ole kytettviss.  
ERROR_MAXIMUM_COPIES_REACHED=Yhteen tietokoneeseen asennettavien DB2-kopioiden enimmismr on 16. DB2:n asennusohjelma ei voi jatkaa asennusta.
ERROR_ANOTHER_SETUP_RUNNING=Toinen ohjatun DB2-ohjelmiston asennustoiminnon kopio on jo ajossa. Jotta voit jatkaa, sinun on odotettava kyseisen asennustoiminnon loppumista. Jos hiri ei poistu, kynnist tietokone uudelleen ja aja DB2:n asennusohjelma uudelleen.
ERROR_RSP_FILE_INVALID=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. Tiedostoa ei ole.
ERROR_RSP_FAIL_READ_KEY=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. Avainsanan '%s' arvo puuttuu tai sit ei voi lukea.
ERROR_RSP_KW_NOT_FOUND=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. Pakollista avainsanaa '%s' ei ole vastaustiedostossa.
ERROR_RSP_KW_NO_VALUE=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. Avainsanasta '%s' puuttuu arvo vastaustiedostossa.
ERROR_RSP_OPEN_FAILED=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. DB2:n asennusohjelma ei onnistunut avaamaan tai kyttmn tt vastaustiedostoa. 
ERROR_RSP_KW_INVALID=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. Avainsana '%s' ei ole kelvollinen vastaustiedostossa.
ERROR_RSP_VALUE_INVALID=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. Avainsanassa '%s' on virheellinen arvo '%s'.
ERROR_NOMEM=VIRHE: Toiminnon toteutukseen tarvittavan muistin varaus ei onnistu. Vapauta muistia ja aja asennusohjelma uudelleen. 
ERROR_RSP_INIT_FAILED=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. DB2:n asennusohjelma ei onnistunut alustamaan vastaustiedostoa.
ERROR_RSP_PROD_NOT_IN=VIRHE: Vastaustiedostossa '%s' on ilmennyt ongelma. Tuote '%s' ei ole kytettviss tss asennuksessa.
ERROR_TRE_CREATE_FAILED=VIRHE: Jljitystiedoston '%s' luonti ei onnistunut.
ERROR_LAUNCH_TOOLS_INSTALL_FAILED=DB2:n asennusohjelma ei voi aloittaa kohteen %s asennusta. Jos ongelma toistuu, ota yhteys tekniseen tukeen.
# {0} in ERROR_BROWSER_NOT_FOUND is replaced with a list of supported browsers.
ERROR_BROWSER_NOT_FOUND=Web-sivun tarkastelu ei onnistu, koska tuettua selainta ei lydy.\n\nVarmista, ett jokin seuraavista selaimista on asennettu ja ett selain on asennettu hakemistoon, joka on mritetty PATH-ympristmuuttujaan:\n{0}
ERROR_INSTALL_COPY_NAME=VIRHE: Annettu DB2-kopion nimi ei kelpaa. DB2-kopion nimi voi olla enintn 64 merkki pitk, ja se voi sislt seuraavia merkkej: A - Z, a - z ja 0 - 9. DB2-kopion nimen ensimminen merkki ei voi olla numero.
ERROR_ADMIN_AUTH_REQUIRED=Kyttjll ei ole oikeuksia ohjelman %s asennukseen. Kirjaudu sisn pkyttjn oikeuksin ja yrit uudelleen.

FONT0=Arial Bold
FONTSIZE0=12

FONT1=Arial Bold
FONTSIZE1=22

FONT2=Arial
FONTSIZE2=8

FONT3=Arial
FONTSIZE3=10

FONT4=Arial
FONTSIZE4=9

FONT5=Arial
FONTSIZE5=6

FONT6=Times New Roman Bold
FONTSIZE6=28

FONT7=Arial
FONTSIZE7=9

FONT8=Arial Bold
FONTSIZE8=12

FONT9=Arial
FONTSIZE9=10

FONT10=Times New Roman
FONTSIZE10=12

JFONT1=TimesNew
JFONTSIZE1=18

JFONT2=TimesNew
JFONTSIZE2=22

JFONT3=TimesNew
JFONTSIZE3=10

JFONT4=Helvetica
JFONTSIZE4=12

JFONT5=Helvetica
JFONTSIZE5=8

JFONT6=Helvetica
JFONTSIZE6=32

JFONT7=Helvetica
JFONTSIZE7=12

JFONT8=TimesNew
JFONTSIZE8=16

JFONT9=Helvetica
JFONTSIZE9=12

JFONT10=TimesNew
JFONTSIZE10=12

IPNEXTBTN=Seuraava >
IPBACKBTN=Edellinen
IPHELPBTN=Ohje


IPHEADER=Valitse asennettava ohjelma

OK=OK
CANCEL=Peruutus
CONTINUE=Jatko
BROWSE=Selaus
WSASNOTFOUND=Mritetty tallennusvline ei kelpaa.  Yrit uudelleen.
WSASREMOVEPOPUP=Poista WebSpheren CD-tietolevy asemasta ja aseta DB2:n CD-tietolevy uudelleen asemaan.  Jatka napsauttamalla OK-painiketta, etsi DB2:n asennusohjelma manuaalisesti napsauttamalla Selaus-painiketta tai peruuta napsauttamalla Peruutus-painiketta.
LOWER_BIT_INSTALL_ERROR=Tm DB2-tuote voidaan asentaa vain 32-bittiseen Windows-jrjestelmn.  Voit keskeytt asennuksen valitsemalla '%s'-painikkeen.
HIGHER_BIT_INSTALL_ERROR=Tm DB2-tuote voidaan asentaa vain 64-bittiseen Windows-jrjestelmn.  Voit keskeytt asennuksen valitsemalla '%s'-painikkeen.
ERROR_HEADER=Virhe
WARNING_HEADER=Varoitus
WARNING_LOGFILE_OVERWRITE=Mritetty lokitiedosto on jo luotu.  Jatko korvaa aiemmin luodun lokitiedoston.  Jatka napsauttamalla Kyll-painiketta tai lopeta asennus napsauttamalla Ei-painiketta.

IERR_FIXPAK_REF_NOTFOUND=Asennus on eponnistunut, koska jrjestelmss olevan DB2-tuotteen %s korjauspaketin nkistiedostoa ei ole lytynyt samasta paikasta kuin nykyisen asennuksen nkistiedosto. Varmista, ett tuotteen %s korjauspaketin nkistiedosto on samassa yltason hakemistossa.
IERR_FIXPAK_REF_MULT_NOTFOUND=Asennus on eponnistunut, koska jrjestelmss olevien DB2-tuotteiden - (%s) - kaikkia korjauspaketin nkistiedostoja ei ole lytynyt samasta paikasta kuin nykyisen asennuksen nkistiedosto. Varmista, ett kaikkien jrjestelmss olevien DB2-tuotteiden korjauspaketin nkistiedostot ovat samassa yltason hakemistossa.

IMSG_PICKER_MAINWINDOW=Aiemmin luodun DB2-kopion ksittely
# {0} in the string below is replaced with a DB2 product name
IMSG_PICKER_MAINWINDOW_UNIX={0} - Aiemmin luodun DB2-kopion ksittely
IMSG_PICKER_HEADER=Ksiteltvn DB2-kopion valinta
IMSG_PICKER_UP=Tietokoneessa on havaittu seuraavat DB2-kopiot. Valitse haluamasi DB2-kopio ja sille toteutettava toiminto.
IMSG_PICKER_CHECKBUTTON=&Kaikkien DB2-kopioiden (mys niiden, joihin ei liity toimintoa) nytt
IMSG_PICKER_LAUNCHBUTTON=&Ohjatun DB2-ohjelmiston asennustoiminnon ajo
IMSG_PICKER_CANCELBUTTON=Peruutus
IMSG_PICKER_HELPBUTTON=Ohje
IMSG_PICKER_DITAILS=Kuvausesitys:
IMSG_PICKER_ACTION_NOTAVAILABLE=Ei kytettviss
IMSG_PICKER_ACTION_UPGRADE=Pivitys
IMSG_PICKER_ACTION_INSTALL=Asennus
IMSG_PICKER_ACTION_ADDNEWFUN=Uuden toiminnon lisys
IMSG_PICKER_ACTION_MIGRATE=Siirto
IMSG_PICKER_ACTION_DESCRIPTION_NOTAVAILABLE=Toimia ei ole kytettviss. Jos asennat alemmalla kooditasolla olevan tuotteen, lataa samalla kooditasolla oleva asennuksen nkistiedosto kuin se, joka on asennettu thn DB2-kopioon, seuraavasta sijainnista: 
IMSG_PICKER_ACTION_DESCRIPTION_UPGRADE=Pivit %s korjauspaketin avulla. Jos valitussa DB2-kopiossa on useampia kuin yksi tuote, myhemmin tarvitaan muiden tuotteiden korjauspaketteja
IMSG_PICKER_ACTION_DESCRIPTION_UPGRADE_UNIX_NOSUP=Toimia ei ole kytettviss.  Jos olet pivittmss tuotetta {0} valittuun DB2-kopioon, lopeta nykyinen asennus ja aja installFixPack-komento.
IMSG_PICKER_ACTION_DESCRIPTION_INSTALL=Kohteen %s asennus valittuun DB2-ohjelmiston kopioon
IMSG_PICKER_ACTION_DESCRIPTION_INSTALL_UNIX=Kohteen {0} asennus valittuun DB2-ohjelmiston kopioon
IMSG_PICKER_ACTION_DESCRIPTION_ADDNEWFUN=Uuden funktion lisys valittuun DB2-ohjelmiston kopioon.
IMSG_PICKER_ACTION_DESCRIPTION_ADDPRODUCT=Toimia ei ole kytettviss. Tuotteen %s asennus ei onnistu, koska tss asennussijainnissa ei ole asennuksen edellyttm DB2-tuotetta. Asenna jokin seuraavista tuotteista, ennen kuin asennat tuotteen%s: 
IMSG_PICKER_ACTION_DESCRIPTION_MIGRATE=Kohteen %s siirto DB2-ohjelmiston versioon %s. Jos valitussa DB2-kopiossa on useampia kuin yksi tuote, kohteen %s siirto poistaa kaikki muut tuotteet ja siirt tmn kopion ilmentymt ja asetukset. 
IMSG_PICKER_ACTION_DESCRIPTION_UPGRADE32TO64=Pivit %s 64-bittiseen DB2-ohjelmiston versioon %s. Jos valitussa DB2-kopiossa on useampi kuin yksi tuote, kohteen %s pivitys poistaa kaikki muut tuotteet ja pivitt kaikki ilmentymt ja asetukset.
IMSG_PICKER_ACTION_DESCRIPTION_MIGRATEVERSION32TO64_NOTAVAILABLE=Jrjestelm ei tue 32-bittisen DB2-ohjelmiston version %s siirtoa 64-bittiseen DB2-ohjelmiston versioon %s. Pivit valittu 32-bittinen DB2-kopio 64-bittiseksi DB2-ohjelmiston versioksi %s tai siirr se 32-bittiseen DB2-ohjelmiston versioon %s. Toteuta sen jlkeen 64-bittisen DB2-ohjelmiston version %s asennus uudelleen.
IMSG_PICKER_ACTION_DESCRIPTION_MIGRATEMULTICOPIES32TO64_NOTAVAILABLE=Jrjestelmn on asennettu useampi kuin yksi 32-bittinen DB2-kopio. 64-bittinen asennus on sallittu vain, jos jrjestelmss on vain yksi 32-bittinen DB2-kopio. Jos ilmentymi on useassa 32-bittisess DB2-kopiossa, ne on siirrettv yhteen 32-bittiseen DB2-kopioon. Poista sitten kaikkien 32-bittisten DB2-ohjelmistokopioiden asennus lukuun ottamatta sit 32-bittist DB2-ohjelmistokopiota, joka sislt kaikki 32-bittiset ilmentymt. Sen jlkeen voit asentaa 64-bittisen DB2-ohjelmiston version %s.
IMSG_PICKER_ACTION_DESCRIPTION_FIXPACK_NOTAVAILABLE=Olet asentamassa kohdetta %s ylemmll ohjelmakoodin tasolla. Pivit valitun DB2-kopion tuotteet asennettavan tuotteen kanssa samalle ohjelmakoodin tasolle. Asenna %s sen jlkeen uudelleen.
IMSG_PICKER_INSTALLATION_NAME=  DB2-kopion nimi:
IMSG_PICKER_VERSION_NAME=  DB2-kopion versio:
IMSG_PICKER_PRODUCTS_NAME=  DB2-kopion tuotteet:
IMSG_PICKER_PATH_NAME=  DB2-asennuspolku:
IMSG_PICKER_ACTION_NAME= Toiminto
IMSG_PICKER_DESCRIPTION_NAME=  Toiminnon kuvaus:
IMSG_PICKER_DEFAULT=(oletusarvo)

IMSG_CLIPICKER_MAINWINDOW=Aiemmin luodun kopion ksittely
IMSG_CLIPICKER_HEADER=Valitse ksiteltv kopio
IMSG_CLIPICKER_INSTALLATION_NAME=  Tuotteen nimi:
IMSG_CLIPICKER_PATH_NAME=  Asennuspolku:
IMSG_CLIPICKER_LAUNCHBUTTON=&Ohjatun asennustoiminnon aloitus
IMSG_CLIPICKER_CHECKBUTTON=&Kaikkien kopioiden (mys niiden, joihin ei liity toimintoa) nytt
IMSG_CLIPICKER_UP=Tietokoneessa on havaittu seuraavat kopiot. Valitse haluamasi kopio ja sille toteutettava toiminto.

# new Strings for the Viper launchpad on Unix/Linux
# added by Ryan Chase

#### START OF LAUNCHPAD GROUP ####
# NOTE TO TRANSLATOR: the mnemonics for the buttons below must be different from 
#  each other as they are shown on the same page.

LPAD_BUTTON=Aloitus
LPAD_BUTTON_MNEM=A

NR_INSTALL_BUTTON=Ilman pkyttjn oikeuksia tehtvn asennuksen tiedot
NR_INSTALL_BUTTON_MNEM=M

INSTALL_PREREQS_BUTTON=Asennukseen liittyvi tietoja
INSTALL_PREREQS_BUTTON_MNEM=V

RELNOTES_BUTTON=Tietoja versiosta
RELNOTES_BUTTON_MNEM=R

MIGRATION_BUTTON=Siirtotiedot
MIGRATION_BUTTON_MNEM=T

INSTALL_BUTTON=Tuotteen asennus
INSTALL_BUTTON_MNEM=O

EXISTING_BUTTON1=Aiemman ksittely
#EXISTING_BUTTON1_MNEM=E
EXISTING_BUTTON2=Aiemman pivitys
EXISTING_BUTTON2_MNEM=P

INSTALLNEW_BUTTON=Uuden asennus
#INSTALLNEW_BUTTON_MNEM=w

INSTALL_EXTERNAL_BUTTON =Asennus
#INSTALL_EXTERNAL_BUTTON_MNEM=l

EXIT_BUTTON=Lopetus
EXIT_BUTTON_MNEM=L

#                              #
#### END OF LAUNCHPAD GROUP ####

IMSG_PICKER_UNIX_LAUNCHBUTTON=Ohjatun DB2-ohjelmiston asennustoiminnon aloitus
IMSG_PICKER_UNIX_LAUNCHBUTTON_MNEM=B

LPAD_WELCOME_TITLE={0}
LPAD_WELCOME_TITLE_DB2={0}, tervetuloa kyttmn DB2-ohjelmiston versiota {1}
LAPD_WELCOME_TITLE_IBM_DATA_SERVER={0}, tervetuloa kyttmn IBM Data Server -ohjelmiston versiota {1}

# LPAD_WELCOME_DESC1 and LPAD_WELCOME_DESC2 are shown on the welcome page of the Launchpad, one after the other.
LPAD_WELCOME_DESC1=DB2-ohjelmiston asennuksen aloitusohjelman avulla voit kytt kaikkia tietoja, joita tarvitset DB2-tuotteiden ja -ominaisuuksien asennukseen Linux-, UNIX- ja Windows-kyttjrjestelmiss.
LPAD_WELCOME_DESC2=Jos haluat listietoja DB2-tuotteista, jotka voi asentaa, tai jos haluat asentaa niit, valitse jokin vlilehdist. 
LPAD_WELCOME_DESC3=Listietoja tuotteista on Opastuksessa.
LPAD_WELCOME_SEARCH_IC=Haku Opastuksesta

LPAD_NR_INSTALL_TITLE=Ilman pkyttjn oikeuksia tehtvn asennuksen tiedot
LPAD_NR_INSTALL_DESC1=DB2:n asennusohjelma on ajossa muulla kuin pkyttjn (root) tunnuksella. Tietoja muulla kuin pkyttjn tunnuksella tapahtuvasta asennuksesta on alla. 
LPAD_NR_INSTALL_LINK_OVERVIEW=Ilman pkyttjn oikeuksia tehtvn asennuksen yleiskuvaus
LPAD_NR_INSTALL_LINK_REQTS=Ilman pkyttjn oikeuksia tehtvn asennuksen edellytykset
LPAD_NR_INSTALL_LINK_LIMIT=Ilman pkyttjn oikeuksia tehtvn asennuksen rajoitukset

LPAD_PREREQS_TITLE=Asennukseen liittyvi tietoja
LPAD_PREREQS_DESC1=Ennen kuin asennat DB2-tuotteen, varmista, ett jrjestelm tytt kaikki asennuksen edellytykset, mukaan luettuna kyttjrjestelmkorjaukset.  Nin vltt tekniset ongelmat, joita muutoin saattaisi ilmet tuotteiden asennuksen ja kokoonpanon mrityksen aikana ja niiden jlkeen.
LPAD_PREREQS_LINK_INFO=DB2-ohjelmiston vaatimukset
LPAD_PREREQS_LINK_REQTS=DB2-ohjelmiston levy- ja muistivaatimukset
LPAD_PREREQS_NRINSTINFO=Voit tarkastella ilman pkyttjn oikeuksia tehtvn asennuksen edellytyksi napsauttamalla vaihtoehtoa {0}.

LPAD_RELNOTES_TITLE=Tietoja versiosta
LPAD_RELNOTES_DESC1=Viimeisimmt tuotetiedot ovat Tietoja versiosta -aiheissa.
LPAD_RELNOTES_LINK=Tietoja versiosta
LPAD_RELNOTES_NEW_DESC=Tietoja tmn laitoksen uusista ominaisuuksista on Uudet ominaisuudet -aiheissa.
LPAD_RELNOTES_NEW_LINK=Uudet ominaisuudet
LPAD_RELNOTES_CHANGED_DESC=Listietoja version {0} muuttuneista, vanhentuneista tai lopetetuista toiminnoista on Muuttuneet toiminnot -aiheissa.
LPAD_RELNOTES_CHANGED_LINK=Muuttuneet toiminnot

LPAD_MIGR_TITLE=Siirtotiedot
LPAD_MIGR_DESC1=Tietoja siirrosta DB2-ohjelmiston thn laitokseen aiemmasta laitoksesta tai muusta tietokantatuotteesta on kohdassa DB2-ohjelmiston siirron esittely.
LPAD_MIGR_LINK=DB2-ohjelmiston siirron esittely

LPAD_INSTALL_TITLE=Tuotteen asennus: {0}
LPAD_INSTALL_DESC1=Aloita haluamasi tuotteen ohjattu DB2-ohjelmiston asennustoiminto ja asenna tuote uuteen sijaintiin napsauttamalla Uuden asennus -painiketta.
LPAD_INSTALL_DESC2=Jos haluat asentaa lisominaisuuksia aiemmin asennettuun tuotteeseen, napsauta Aiemman pivitys -painiketta.
LPAD_INSTALL_DESC3=Jos haluat asentaa lisominaisuuksia aiemmin asennettuun tuotteeseen, napsauta Aiemman ksittely -painiketta.
#LPAD_INSTALL_DESC4 is shown in combination with one or more of the above sentences.
LPAD_INSTALL_DESC4=Voit aloittaa mys muiden tuotteiden asennukset napsauttamalla haluamasi tuotteen Asennus-vaihtoehtoa.

WARNING_MIGRATION_HEADER=Siirto pivitt muutokset DB2-kopioon. Jotkin nist muutoksista saattavat edellytt seuraavia siirtoa edeltvi tai siirron jlkeisi toimia:
WARNING_NEED_TO_RUN_DB2CKMIG=1. Aiemmin luotujen paikallisten tietokantojen kytt tuotteessa %s edellytt, ett aiemmin luodut paikalliset tietokannat on siirretty, kun %s on asennettu. DB2CKMIG-komento tarkistaa, onko paikallisten tietokantojen siirrolle esteit. Komento db2ckmig on ajettava nykyisen asennetun DB2-version avulla ennen tuotteen %s asennusta. Tietokantoja ei voi tarkistaa nykyisell DB2-versiolla, kun %s on asennettu. Komento db2ckmig sijaitsee asennusvlineen hakemistossa %s. 
WARNING_UNINSTALL_PRODUCTS=2. Kaikki aiemmin asennetut DB2-kopion %s siirrettvt DB2-tuotteet poistetaan. Siirto asentaa tuotteen %s kopion. Muut kuin %s-DB2-tuotteet on asennettava erikseen siirron jlkeen.
WARNING_CONTINUE=Jatka napsauttamalla OK-painiketta tai lopeta DB2:n asennusohjelma ja varmista, ett DB2-kopio %s on valmis siirtoon, napsauttamalla Peruuta-painiketta. 
MIGRATION_REMOVING_DB2=Vanhojen DB2-tuotteiden poisto on meneilln. Odota.

NO_VALID_PROD_IDENTIFIER=Tuotteen nkistiedostossa ei ole kelvollista tunnusta, jonka avulla asennusohjelma voisi nytt kytettviss olevat vaihtoehdot. Tuotteen nkistiedostoa on muutettu. Asenna DB2-tuotteen alkuperisen nkistiedoston avulla.

# the below messages for InstallLauncher Only
IMSG_LAUNCHER_ERROR_COPYPATH=Mritetty asennushakemisto "%s" ei kelpaa.
IMSG_LAUNCHER_ERROR_UNKNOWN_PARAM=Vhintn yksi parametri ei kelpaa.
IMSG_LAUNCHER_INSTALLTYPE_WARNING=Asennus toteuttaa kohteen %s - %s yllpidon tai pivitysasennuksen. Jos haluat asentaa uuden IBM-tietokantapalvelimen ajurin kopion, aja asennus valinnalla /o tai /n <kopion_nimi>. Haluatko jatkaa?
IMSG_LAUNCHER_COPYNAME_PATH_CONFLICT=Mritetty kopion nimi ei vastaa mritetty asennussijaintia.  Varmista, ett kopion nimi vastaa asennussijaintia.
  

# the below message is for non-root install only
IMSG_NR_INSTALL_NOT_SAME_AS_IMAGE=Aiemmin asennettujen DB2-tuotteiden taso ei vastaa asennettavaksi valitun tuotteen tasoa. Jos asennat alemmalla kooditasolla olevan tuotteen, lataa aiemmin asennettujen DB2-tuotteiden kanssa samalla kooditasolla oleva asennuksen nkistiedosto. Jos olet asentamassa ylemmll ohjelmakoodin tasolla olevaa tuotetta, aiemmin asennetut DB2-tuotteet on ensin pivitettv ajamalla installFixPack-komento.

# the below message shows up before installing VSAI's ProjectAggregator2.msi
INSTALL_PROJECTAGGREGATOR2=Microsoft Visual Studio ProjectAggregator2 -komponentin asennus on meneilln.  CLR-sovellusten tallennettujen SQL-toimintosarjojen vianmrityksen tuki edellytt komponentin asennusta.  Tm komponentti saattaa olla yhteiskytss muiden Visual Studio -laajennusten kanssa.  Sen asennusta ei saa poistaa, ellei IBM Database Add-Ins for Visual Studio 2005 -lisosien asennuksia poisteta samalla.  Komponentin asennusta ei ehk kannata poistaa, jos se on mys muiden Visual Studio -laajennusten kytss.  Tt komponenttia ei asenneta asennuksessa, joka ei edellyt kyttjn toimia.

# This is temporary. This string should really go into miscstrwi.txt, but we don't have another MRI shipment for miscstrwi.txt until Cobra
WI_MSG_DISK_SIZE=Levytila
